<?php
/*
 * Created on 06.06.2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 *
 *
 * $Id: DOMCompare.php 189 2007-06-13 14:22:18Z nmarkgraf $
 */
/**
 * The class DOMCompare helps us to find out if two DOMDocuments are DOM-equal.
 *
 * @author 		Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright 	Copyright in 2006, 2007 by The OpenDocumentPHP Team
 * @license 	http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version    	$Revision: 189 $
 * @package    	OpenDocumentPHP
 * @subpackage	tools
 * @since 		0.5.2 - 06.06.2007
 */
//define("DOMCompareDEBUG","DEBUG");

class DOMCompare {
	/**
	 * This is a DEBUG method. It prints out some data of a DOMElement.
	 * 
	 * @param	string	$msg	A message, normaly the name of the DOMElement.
	 * @param	DOMElement	$elem	The DOMElement to print.
	 * @since	0.5.3 - 13.06.2007 
	 * 
	 */
	static function printDOMElement($msg, DOMElement $elem) {
		echo 'Element		:'.$msg."\n";
		echo 'nodeType	:';
		switch ($elem->nodeType) {
			case (XML_TEXT_NODE) :
				echo 'XML TEXT NODE';
				break;
			case (XML_ELEMENT_NODE) :
				echo 'XML ELEMENT NODE';
				break;
			case (XML_ATTRIBUTE_NODE) :
				echo 'XML ATTRIBUTE NODE';
				break;
			case (XML_CDATA_SECTION_NODE) :
				echo 'XML CDATA SECTION NODE';
				break;				
			default:
				echo $elem->nodeType;
		}
		echo "\n";
		echo 'localName	:'.$elem->localName."\n";
		echo 'namespaceURI	:'.$elem->namespaceURI."\n";
		echo 'nodeValue		:'."'".$elem->nodeValue."'\n";
		echo "-------------------------------------------\n";
	}
	/**
	 * This method tests, if the two DOMAttr nodes $attr1 and $attr2 have the same value.
	 * 
	 * @return		bool true, if $attr1 and $attr2 have the same value.
	 * @param		DOMAttr $attr1 
	 * @param		DOMAttr	$attr2
	 * @since 		0.5.2 - 06.06.2007	 
	 */
	static function compareAttributes(DOMAttr $attr1, DOMAttr $attr2) {
		/*
		DOMCompare::printDOMElement('$attr1', $attr1);
		DOMCompare::printDOMElement('$attr1', $attr1);
		*/
		if ($attr1->value != $attr2->value) {			
			return false;
		}
		return true;
	}
	/**
	 * This method checks if an DOMText is just a "whitespace" only.
	 * 
	 * @return		bool	true, if the DOM text node is whitespace only, else return false.
	 * @param		DOMText $elem The DOM text node to check
	 * @since 		0.5.3 - 13.06.2007
	 */
	static function isWhitespaceOnly(DOMText $elem) {		
		if ($elem->hasChildNodes()) {
			// If this text node has children, it can not be a whitespace only node!
			return false;
		}
		$tmp = trim($elem->nodeValue);
		if (strlen($tmp)>0) {
			return false;			
		}		
		return true;
	}
	
	/**
	 * This method compares two DOMElements.
	 * 
	 * @return		bool	True only if the two DOMElements are DOM-equal.
	 * @param		DOMElement	$elem1 First DOMElement to compare.
	 * @param		DOMElement	$elem2 2nd DOMElement to compare. 
	 * @since 		0.5.2 - 06.06.2007	 
	 */
	static function compareElements(DOMElement $elem1, DOMElement $elem2) {
		// First normalize the current elements
		$elem1->normalize();
		$elem2->normalize();
		/*
		DOMCompare::printDOMElement('$elem1', $elem1);
		DOMCompare::printDOMElement('$elem2', $elem2);
		*/ 
		if ($elem1->localName != $elem2->localName) {
			return false;
		}
		//
		if ($elem1->namespaceURI != $elem2->namespaceURI) {
			return false;
		}
		// 
		if ($elem1->hasAttributes() != $elem2->hasAttributes()) {
			return false;
		}
		if ($elem1->hasAttributes()) {
			foreach ($elem1->attributes as $tmp => $attr1) {
				if ($attr1->namespaceURI != null) {
					if (!$elem2->hasAttributeNS($attr1->namespaceURI, $attr1->localName)) {
						return false;
					}
					$attr2 = $elem2->getAttributeNodeNS($attr1->namespaceURI, $attr1->localName);
					$result = DOMCompare :: compareAttributes($attr1, $attr2);
					if (!$result) {
						return false;
					}
				} else {
					if (!$elem2->hasAttribute($attr1->localName)) {
						return false;
					}
					$attr2 = $elem2->getAttributeNode($attr1->localName);
					$result = DOMCompare :: compareAttributes($attr1, $attr2);
					if (!$result) {
						return false;
					}
				}
			}
		}
		//
		if ($elem1->hasChildNodes() != $elem2->hasChildNodes()) {
			return false;
		}
		if ($elem1->hasChildNodes()) {
			$i = 0;
			foreach ($elem1->childNodes as $child1) {
				if ($child1->nodeType != XML_TEXT_NODE || !DOMCompare::isWhitespaceOnly($child1)) {
					$child2 = $elem2->childNodes->item($i);
					// 
					if (is_null($child2)) {
						return false;
					}
					//
					if ($child2->nodeType == XML_TEXT_NODE) {
						// Skipp all TextNodes which are whitespaces only.
						while ( ($child2 !== null) &&
								($child2->nodeType == XML_TEXT_NODE) &&
								(DOMCompare::isWhitespaceOnly($child2))) {
							$i++;
							$child2 = $elem2->childNodes->item($i);
						}
					}
					if ($child2 == null) {
						return false;
					}
					$i++;
					$result = true;
/* *** FIX ME ***					
				if ($child2->nodeType == XML_TEXT_NODE && $child1->nodeType != XML_TEXT_NODE) {
					// *** FIX ME *** This is definitly not correct!!!!
					$child2 = $elem2->childNodes->item($i);
					$i++;
				}
*/
					switch ($child1->nodeType) {
						case (XML_ELEMENT_NODE) :
							if ($child2->nodeType != XML_ELEMENT_NODE) {
								return false;
							}
							$result = DOMCompare :: compareElements($child1, $child2);
							break;
						case (XML_TEXT_NODE) :
							// Check if this XML_TEXT_NODE is importend or 'just' an
							// text adjustment. (Like a simple line break, only spaces or tabs)
							// *** FIX ME ***
							if ($child2->nodeType != XML_TEXT_NODE) {
								$i--;
							}
							break;
						default :
							
					}
					if (!$result) {
						return false;
					}
				}
			}
		}				
		if (trim($elem1->nodeValue) != trim($elem2->nodeValue)) {
			return false;
		}
		return true;
	}
	/**
	 * This is the main compare method of this class.
	 * 
	 * @return	bool	Returns only <b>true</b>, if the two DOMDocuments are DOM-equal.
	 * @param	DOMDocument	$doc1	The first DOMDocument to compare.	
	 * @param	DOMDocument	$doc2	The 2nd DOMDocument to compare.
	 * @since 		0.5.2 - 06.06.2007
	 */
	static function compare(DOMDocument $doc1, DOMDocument $doc2) {
		// First we normalize the documents, just to be sure that the DOM parser gets them right. 
		// This should probably bring nothing, but should not hurt either.
		$doc1->normalizeDocument();
		$doc2->normalizeDocument();
		//
		return ( DOMCompare :: compareElements($doc1->documentElement, $doc2->documentElement) && DOMCompare :: compareElements($doc2->documentElement, $doc1->documentElement) );
	}

}
?>